# API Endpoints

## 3DS Return Data Management

### GET /api/3ds-return
Retrieves stored 3DS return data.

**Response:**
```json
{
  "success": true,
  "data": {
    "TransactionId": "string",
    "Response": "string", 
    "MD": "string",
    "timestamp": "string"
  }
}
```

### POST /api/3ds-return
Stores 3DS return data from external 3DS provider.

**Request Body:**
```json
{
  "TransactionId": "string",
  "Response": "string",
  "MD": "string"
}
```

**Response:**
```json
{
  "TransactionId": "string",
  "Response": "string",
  "MD": "string",
  "timestamp": "string"
}
```

### DELETE /api/3ds-return
Clears stored 3DS return data.

**Response:**
```json
{
  "success": true,
  "message": "3DS return data cleared successfully"
}
```

## 3DS Proxy Endpoints

### POST /api/proxy/v2/threeds-authentication-setup
Proxies authentication setup request to 3DS provider.

### POST /api/proxy/v2/threeds-authentication
Proxies authentication request to 3DS provider.

### POST /api/proxy/v2/threeds-challenge-result
Proxies challenge result request to 3DS provider.

### POST /api/proxy/v2/initialization
Proxies initialization request to 3DS provider.

## Integration

The 3DS service automatically clears return data after successful processing:
- When authentication is accepted without challenge (`doAuthentication`)
- When challenge results are successfully processed (`getChallengeResults`)

This ensures clean state for subsequent 3DS operations.
