# Environment Variables

## Server-side (.env file)

Create a `.env` file in the root directory with the following variables:

```bash
# 3DS Base URL - Default is HML environment
THREEDS_BASE_URL=https://example.threeds.tech

```

## Client-side (Browser localStorage)

The following variables are stored in browser localStorage and can be configured via the Settings page:

- `zroBankBaseUrl`: ZroBank API base URL
- `zroBankApiId`: ZroBank API ID
- `zroBankApiKey`: ZroBank API Key
- `resultUrl`: Return URL for 3DS authentication
- `proxyBaseUrl`: Proxy server base URL

## Usage

1. **Server**: The server reads `THREEDS_BASE_URL` from the `.env` file
2. **Client**: The browser reads configuration from localStorage (set via Settings page)
3. **Docker**: Environment variables can be overridden in docker-compose.yml or .env file
