# Docker Deployment Guide

## Environment Variables

The application uses the following environment variable:

- `THREEDS_BASE_URL`: The base URL for the 3DS service (default: https://example.threeds.tech)

## Building and Running with Docker

### Option 1: Using Docker directly

1. Build the image:
```bash
docker build -t acquirer-3ds .
```

2. Run the container:
```bash
# Using default THREEDS_BASE_URL
docker run -p 3030:3030 acquirer-3ds

# Using custom THREEDS_BASE_URL
docker run -p 3030:3030 -e THREEDS_BASE_URL=https://your-3ds-url.com acquirer-3ds
```

### Option 2: Using Docker Compose

1. Create a `.env` file:
```bash
# Copy the example file
cp env.example .env

# Edit the .env file with your configuration
# .env
THREEDS_BASE_URL=https://example.threeds.tech
```

2. Run with docker-compose:
```bash
# Using .env file
docker-compose up -d

# Or using custom environment file
docker-compose --env-file .env up -d
```

## Health Check

The application includes a health check that verifies the server is responding on port 3030.

## Security Features

- Runs as non-root user (nextjs:nodejs)
- Uses Alpine Linux for smaller image size
- Only production dependencies are installed
- Health checks for container orchestration
