# Acquirer 3DS HML Documentation

Documentation and testing environment for 3DS (3D Secure) acquirer integration.

## Important

**This project only works with ngrok to expose port 3030.** ngrok is required to create a public tunnel that allows external services (such as the 3DS gateway) to access the local application.

## Prerequisites

- Node.js (version 14 or higher)
- npm or yarn
- ngrok installed and configured

## Step-by-Step Guide to Run the Project

### 1. Install Dependencies

Open the terminal at the project root and run:

```bash
npm install
```

### 2. Create Environment Variables File

Create a `.env` file at the project root with the following content:

```bash
# 3DS Base URL - Default is HML environment
THREEDS_BASE_URL=https://example.threeds.tech
```

**Note:** If you need to use another environment, adjust the URL accordingly.

### 3. Install and Configure ngrok

If you don't have ngrok installed yet, follow the steps below:

#### 3.1. Install ngrok

**Linux/macOS:**
```bash
# Using Homebrew (macOS)
brew install ngrok/ngrok/ngrok

# Or download directly
# https://ngrok.com/download
```

**Windows:**
- Download ngrok at: https://ngrok.com/download
- Extract the file and add it to the system PATH

#### 3.2. Create Account and Get Token (if you don't have one)

1. Access https://dashboard.ngrok.com/signup
2. Create a free account
3. Copy the authentication token

#### 3.3. Authenticate ngrok

```bash
ngrok config add-authtoken YOUR_TOKEN_HERE
```

### 4. Start the Application Server

In a terminal, run:

```bash
npm start
```

The server will be running at `http://localhost:3030`.

You will see the message:
```
Server running at http://localhost:3030
```

### 5. Expose Port 3030 with ngrok

**In another terminal**, run ngrok to expose port 3030:

```bash
ngrok http 3030
```

You will see an output similar to:

```
ngrok

Session Status                online
Account                       your-email@example.com
Version                       3.x.x
Region                        United States (us)
Latency                       50ms
Web Interface                 http://127.0.0.1:4040
Forwarding                    https://xxxx-xxxx-xxxx.ngrok-free.app -> http://localhost:3030

Connections                   ttl     opn     rt1     rt5     p50     p90
                              0       0       0.00    0.00    0.00    0.00
```

### 6. Configure the ngrok URL in the Application

**Copy the ngrok URL** (example: `https://xxxx-xxxx-xxxx.ngrok-free.app`).

This URL will be used as `resultUrl` in the application settings to receive returns from the 3DS flow.

### 7. Access the Application

Open your browser and access:

- **Main application:** `https://xxxx-xxxx-xxxx.ngrok-free.app`

### 8. Configure Variables in the Browser

1. Access the Settings page: `https://xxxx-xxxx-xxxx.ngrok-free.app/settings.html`
2. Configure the following variables:
   - `zroBankBaseUrl`: https://api-payments-gateway.zrobank.xyz
   - `zroBankApiId`: ZroBank API ID
   - `zroBankApiKey`: ZroBank API Key
   - `resultUrl`: **Use the ngrok URL obtained in step 5** (example: `https://xxxx-xxxx-xxxx.ngrok-free.app/api/3ds-return`)
   - `proxyBaseUrl`: Proxy URL (usually `https://xxxx-xxxx-xxxx.ngrok-free.app`)

## Terminal Summary

To run the complete project, you need **2 open terminals**:

1. **Terminal 1:** Node.js Server
   ```bash
   npm start
   ```

2. **Terminal 2:** ngrok
   ```bash
   ngrok http 3030
   ```

## Verification

To verify that everything is working:

1. The server should be responding at `http://localhost:3030`
2. ngrok should show "Session Status: online"
3. The public ngrok URL should be accessible (you can test by opening it in your browser)

## Troubleshooting

### Error: "ngrok: command not found"
- Make sure ngrok is installed and in the system PATH
- On Linux, you may need to run: `sudo ln -s /usr/local/bin/ngrok /usr/bin/ngrok`

### Error: "port 3030 is already in use"
- Check if another process is using port 3030: `lsof -i :3030` (Linux/macOS) or `netstat -ano | findstr :3030` (Windows)
- End the process or change the port in the `server.js` file

### ngrok is not connecting
- Check your internet connection
- Make sure the ngrok token is configured correctly
- Check if the firewall is not blocking the connection

### CORS Issues
- The server is already configured to allow CORS from any origin
- If you still have problems, check if you're using the ngrok URL correctly

## About the Proxy API

This project eliminates the need to implement all the communication logic with 3DS APIs directly in your backend, providing intermediate endpoints (proxy) that handle complex communication while your frontend only needs to call simpler local APIs.

The proxy API was created to **avoid CORS (Cross-Origin Resource Sharing) errors** when making requests from the frontend directly to the 3DS gateway endpoints. Therefore, an internal server was created that acts as an intermediary between your frontend and the gateway APIs.

### When to use the Proxy

Use the proxy endpoints (`/api/proxy/v2/...`) when:
- You are making direct calls from the frontend (JavaScript in the browser)
- You encounter CORS errors when calling the gateway directly
- You need an intermediate access point

### Calling 3DS Endpoints Directly

If the proxy is not necessary (for example, if you're making calls from the backend or if the gateway allows CORS), you can call the 3DS endpoints directly:

**Proxy Endpoints (with internal server):**
- `POST /api/proxy/v2/threeds-authentication-setup`
- `POST /api/proxy/v2/threeds-authentication`
- `POST /api/proxy/v2/threeds-challenge-result`

**Direct 3DS Endpoints (without proxy):**
- `POST {THREEDS_BASE_URL}/v2/threeds-authentication-setup`
- `POST {THREEDS_BASE_URL}/v2/threeds-authentication`
- `POST {THREEDS_BASE_URL}/v2/threeds-challenge-result`

**How to use:** Simply use the correct `THREEDS_BASE_URL` (configured in `.env` or directly: `https://example.threeds.tech`) and **remove the `/api/proxy` prefix** from the path.

**Example:**
- With proxy: `http://localhost:3030/api/proxy/v2/threeds-authentication-setup`
- Without proxy: `https://example.threeds.tech/v2/threeds-authentication-setup`

## Additional Documentation

- [Environment Variables](ENV_VARIABLES.md)
- [API Endpoints](API_ENDPOINTS.md)
- [Docker Deployment](README-Docker.md)

## Project Structure

```
acquirer-3ds-hml-doc/
├── public/           # Static files (HTML, CSS, JS)
├── server.js         # Express server
├── package.json      # Project dependencies
├── .env             # Environment variables (create manually)
└── docker-compose.yml # Docker configuration
```
