// Main application script
document.addEventListener('DOMContentLoaded', function() {
    // Reads variables from settings page
    const zroBankBaseUrl = getConfig("zroBankBaseUrl") || "https://api-payments-gateway.zrobank.xyz";
    const zroBankApiId = getConfig("zroBankApiId") || "";
    const zroBankApiKey = getConfig("zroBankApiKey") || "";

    const resultUrl = getConfig("resultUrl") || "http://localhost:3030/api/3ds-return";
    const proxyBaseUrl = getConfig("proxyBaseUrl") || "http://localhost:3030";
  
    const jsonInput = document.getElementById("jsonInput");

    document.getElementById('myForm').addEventListener('submit', async function(event) {
      event.preventDefault();
      
      const submitBtn = document.getElementById('submitBtn');
      const originalText = submitBtn.textContent;
      
      // Adds loading to button
      submitBtn.classList.add('btn-loading');
      submitBtn.textContent = 'Fetching token...';
      submitBtn.disabled = true;
      
      let payload;

      try {
        payload = JSON.parse(jsonInput.value);
      } catch (err) {
        alert("Invalid JSON!");
        // Removes loading from button in case of error
        submitBtn.classList.remove('btn-loading');
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
        return;
      }

      try {
        // Fetches transactionalToken from endpoint
        submitBtn.textContent = 'Getting token...';
        console.log('Getting token from ZroBank...', zroBankBaseUrl);
        console.log('ZroBank API ID:', zroBankApiId);
        console.log('ZroBank API Key:', zroBankApiKey);
        const transactionalToken = await getTransactionalTokenZroBank(zroBankBaseUrl,zroBankApiId,zroBankApiKey);
        console.log('Transactional token:', transactionalToken);
        submitBtn.textContent = 'Starting 3DS Secure request...';
        
        const merchantUrl = "http://zrobank.com.br";

        const generalInformation = {
          protocolVersion: "2.0",
          type: payload.cardInfo.type,
          transactionMode: 'S',
          acsWindowSize: '05',
          deviceChannel: "BROWSER"
        };

        const willAuthenticate = doThreeDs(
          payload.cardInfo,
          payload.billTo,
          payload.amountDetails,
          payload.billTo.phoneNumber,
          merchantUrl,
          resultUrl,
          generalInformation,
          function(userInput) {
            handleAlert(userInput);
          },
          transactionalToken,
          proxyBaseUrl
        );

        if (!willAuthenticate) {
          // Removes loading from button if it fails immediately
          submitBtn.classList.remove('btn-loading');
          submitBtn.textContent = originalText;
          submitBtn.disabled = false;
          handleAlert(undefined);
        }
        
      } catch (error) {
        console.error('Error getting token:', error);
        alert('Error getting token: ' + error.message);
        
        // Removes loading from button in case of error
        submitBtn.classList.remove('btn-loading');
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
      }
    });

    function handleAlert(userInput) {
      if (userInput === undefined) {
        alert("Authentication Failed!");
      } else {
        console.log("Complete 3DS data:", userInput);
        alert("Authenticated! Check console for complete data.");
      }
    }
});
